from ...libs.functions.common_ui_elements import collapsable
from .common_functions import condition_enabled


def springs_adv_ui(toggles, col, active_emitter_item, springs_props, anim_springs_props):

    if not active_emitter_item:
        return

    switchers_props = active_emitter_item.switchers
    
    # global_mode_springs_sect
    springs_local_mode = {
        "type": "bool",
        "from": switchers_props,
        "prop": "global_mode_springs_sect",
        "text": "",
        "toggle": True,
        "icon": 'LINKED' if switchers_props.global_mode_springs_sect else 'UNLINKED',
        "emboss": False,
    }
    springs = collapsable(
        col,
        toggles,
        "fs_springs",
        "Springs",
        'GP_SELECT_STROKES',
        align=True,
        button_settings1=springs_local_mode
    )
    if springs:

        force = springs.row(align=True)
        force.enabled = condition_enabled(anim_springs_props, "spring_force")
        force.prop(springs_props, "spring_force", text="Force")

        springs.separator()

        use_viscoelastic = springs.row(align=True)
        use_viscoelastic.enabled = condition_enabled(anim_springs_props, "use_viscoelastic_springs")
        use_viscoelastic.scale_y = 1.3
        icon_uve = 'TRIA_DOWN' if springs_props.use_viscoelastic_springs else 'TRIA_LEFT'
        use_viscoelastic.prop(springs_props, "use_viscoelastic_springs", text="Viscoelastic", toggle=True)
        use_viscoelastic.prop(springs_props, "use_viscoelastic_springs", text="", toggle=True, icon=icon_uve)

        if springs_props.use_viscoelastic_springs:
            springs.separator()
            ve_settings = springs.column(align=True)

            ve_settings.prop(springs_props, "yield_ratio", text="Elastic Limit", slider=True)
            ve_settings.prop(springs_props, "plasticity", text="Plasticity", slider=True)

            ve_settings.separator()
            ve_settings.prop(springs_props, "use_initial_rest_length", text="Initial Rest Length")
            ve_settings.prop(springs_props, "spring_frames", text="Frames")

            ve_settings.separator()
            ve_settings.prop(springs_props, "use_factor_rest_length", text="Factor Rest Length")
            ve_settings.prop(springs_props, "rest_length", text="Rest Length", slider=True)



